<?php 
include 'header.php';
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistem Pendukung Keputusan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        /* Background Fullscreen */
        body {
            margin: 0;
            padding: 0;
            height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            background: url('img/nsp.jpg') no-repeat center center fixed;
            background-size: cover;
            position: relative;
            color: white;
            text-align: center;
        }

        /* Overlay Gradient (Maroon ke Hitam) */
        body::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(to bottom, rgba(128, 0, 0, 0.7), rgba(0, 0, 0, 0.9));
            z-index: 1;
        }

        .container {
            position: relative;
            z-index: 2;
            max-width: 1200px; /* Lebarkan konten */
            padding: 50px; /* Tambah padding */
        }

        h1 {
            font-size: 50px;
            font-weight: bold;
            margin-bottom: 20px;
        }

        h3 {
            font-size: 32px;
            margin-bottom: 30px;
        }

        p.lead {
            font-size: 22px;
            font-weight: 400;
            margin-bottom: 30px;
        }

        .btn-custom {
            font-size: 30px;
            padding: 28px;
            width: 100%;
            transition: 0.3s;
            font-weight: bold;
            text-align: center;
        }

        .btn-custom:hover {
            transform: scale(1.05);
        }

        /* Tombol sejajar dengan lebar yang sama */
        .button-wrapper {
            display: flex;
            justify-content: center;
            gap: 40px; /* Beri jarak antar tombol */
            margin-top: 40px;
        }

        .button-wrapper a {
            flex: 1;
            max-width: 450px; /* Batasi ukuran maksimum tombol */
        }

        /* RESPONSIVE DESIGN */
        
        /* Untuk HP */
        @media (max-width: 600px) {
            .container {
                max-width: 100%;
                padding: 20px;
            }

            h1 {
                font-size: 32px;
            }

            h3 {
                font-size: 22px;
            }

            p.lead {
                font-size: 16px;
            }

            .btn-custom {
                font-size: 20px;
                padding: 18px;
            }

            .button-wrapper {
                flex-direction: column;
                gap: 15px;
            }

            .button-wrapper a {
                max-width: 100%;
            }
        }

        /* Untuk Tablet */
        @media (min-width: 601px) and (max-width: 1024px) {
            .container {
                max-width: 90%;
                padding: 30px;
            }

            h1 {
                font-size: 42px;
            }

            h3 {
                font-size: 28px;
            }

            p.lead {
                font-size: 18px;
            }

            .btn-custom {
                font-size: 26px;
                padding: 24px;
            }

            .button-wrapper {
                gap: 25px;
            }
        }

        /* Untuk Laptop/PC */
        @media (min-width: 1025px) {
            .container {
                max-width: 1200px;
                padding: 50px;
            }

            h1 {
                font-size: 50px;
            }

            h3 {
                font-size: 32px;
            }

            p.lead {
                font-size: 22px;
            }

            .btn-custom {
                font-size: 30px;
                padding: 28px;
            }

            .button-wrapper {
                gap: 40px;
            }
        }

    </style>
</head>
<body>

<div class="container">
    <h1 class="mb-3">Decision Support System</h1>
    <h3 class="mb-4">for Evaluating the Effectiveness of YouTube Use and Recommending the Best Channel as a Learning Media for Informatics Engineering Students with Weighted Product Method 
</h3>
    <p class="lead">
    This system is used to evaluate the effectiveness of YouTube as a learning media for Informatics Engineering students. 
    and recommend the best channels. Please select one of the systems below.
    </p>
    
    <div class="button-wrapper">
        <a href="index2.php" class="btn btn-primary btn-lg btn-custom">Evaluating The Effectiveness Of Using Youtube As A Learning Media </a>
        <a href="index3.php" class="btn btn-success btn-lg btn-custom">Determining The Best Youtube Channel Recommendations As A Learning Media</a>
    </div>
</div>

</body>
</html>
